	function genfirstim(dir, bitspec, samples)
	%genfirstim(dir, bitspec, samples)
	%
	%Generates stimuli files for use with FIR testbench. The function 
	%generates stimuli files for the inputs, and files containing expected
	%output
	%
	%Arguments:
	%  dir - directory to generate stimuli files in.
	%  bitspec - filter specification structure
	%  samples - number of samples in stimuli.
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	indata = floor(2^bitspec.arith.wdata*rand(1, samples));
	if bitspec.arith.signeddata == 1
		indata = indata - 2^(bitspec.arith.wdata-1);
	end
	
	for b = 1:bitspec.numin
		instim = dectobin(indata(b:bitspec.numin:samples)', bitspec.arith.wdata, bitspec.arith.signeddata);
		dlmwrite(sprintf('%s/x_%d.stim', dir, b-1), instim, '');
	end
	
	for b = 1:bitspec.numout
		outdata = conv(indata, bitspec.branches{b}.h);
		outdata = outdata(bitspec.numin:bitspec.numin:samples);
		outdata = [zeros(1, bitspec.branches{b}.pipedelay) outdata(1:end-bitspec.branches{b}.pipedelay)];
		outstim = dectobin(outdata', bitspec.arith.wout, bitspec.arith.signeddata);
		dlmwrite(sprintf('%s/y_%d.stim', dir, b-1), outstim, '');
	end
	
